% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one_bino_size.R
\name{one_bino_size}
\alias{one_bino_size}
\title{Sample Size or Power for One-Sample Binomial Proportion Test}
\usage{
one_bino_size(p, p0, alpha, beta = NULL, n = NULL)
}
\arguments{
\item{p}{Numeric. True proportion.}

\item{p0}{Numeric. Null hypothesis proportion.}

\item{alpha}{Numeric. Type I error rate.}

\item{beta}{Numeric (optional). Type II error rate. Required for sample size calculation.}

\item{n}{Integer (optional). Sample size. Required for power calculation.}
}
\value{
Numeric. Returns sample size (if \code{beta} is given), or power (if \code{n} is given).
}
\description{
Calculates sample size or power for a two-sample binomial proportion test.
}
\note{
Only one of \code{beta} (for sample size calculation) or \code{n} (for power calculation) should be specified.

Required arguments:
\itemize{
\item For sample size: \code{"p"}, \code{"p0"}, \code{"alpha"}, \code{"beta"}
\item For power: \code{"p"}, \code{"p0"}, \code{"alpha"}, \code{"n"}
}
}
\examples{
# Required sample size
one_bino_size(p = 0.5, p0 = 0.3,
              alpha = 0.05, beta = 0.2)

# Power
one_bino_size(p = 0.5, p0 = 0.3,
              alpha = 0.05, n = 50)

}
