% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class104-epoched_time-frequency.R
\name{RAVESubjectEpochTimeFreqCoefRepository}
\alias{RAVESubjectEpochTimeFreqCoefRepository}
\title{'RAVE' class for epoch repository - time-frequency}
\description{
The repository inherits \code{link{RAVESubjectEpochTimeFreqBaseRepository}}, with epoch
trials, and is intended for loading processed and referenced time-frequency
coefficients.
Use \code{\link{prepare_subject_time_frequency_coefficients_with_epochs}} to create an
instance.
}
\section{Super classes}{
\code{\link[ravepipeline:RAVESerializable]{ravepipeline::RAVESerializable}} -> \code{ravecore::RAVESubjectRepository} -> \code{\link[ravecore:RAVESubjectEpochRepository]{ravecore::RAVESubjectEpochRepository}} -> \code{\link[ravecore:RAVESubjectEpochTimeFreqBaseRepository]{ravecore::RAVESubjectEpochTimeFreqBaseRepository}} -> \code{RAVESubjectEpochTimeFreqCoefRepository}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{coefficients}}{a named map of time-frequency coefficient data,
mounted by \code{mount_data}}

\item{\code{wavelet}}{not used anymore, see \code{coefficients}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RAVESubjectEpochTimeFreqCoefRepository-@marshal}{\code{RAVESubjectEpochTimeFreqCoefRepository$@marshal()}}
\item \href{#method-RAVESubjectEpochTimeFreqCoefRepository-@unmarshal}{\code{RAVESubjectEpochTimeFreqCoefRepository$@unmarshal()}}
\item \href{#method-RAVESubjectEpochTimeFreqCoefRepository-new}{\code{RAVESubjectEpochTimeFreqCoefRepository$new()}}
\item \href{#method-RAVESubjectEpochTimeFreqCoefRepository-clone}{\code{RAVESubjectEpochTimeFreqCoefRepository$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ravepipeline" data-topic="RAVESerializable" data-id="@compare"><a href='../../ravepipeline/html/RAVESerializable.html#method-RAVESerializable-@compare'><code>ravepipeline::RAVESerializable$@compare()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectRepository" data-id="@get_container"><a href='../../ravecore/html/RAVESubjectRepository.html#method-RAVESubjectRepository-@get_container'><code>ravecore::RAVESubjectRepository$@get_container()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectEpochRepository" data-id="export_matlab"><a href='../../ravecore/html/RAVESubjectEpochRepository.html#method-RAVESubjectEpochRepository-export_matlab'><code>ravecore::RAVESubjectEpochRepository$export_matlab()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectEpochRepository" data-id="get_container"><a href='../../ravecore/html/RAVESubjectEpochRepository.html#method-RAVESubjectEpochRepository-get_container'><code>ravecore::RAVESubjectEpochRepository$get_container()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectEpochRepository" data-id="set_epoch"><a href='../../ravecore/html/RAVESubjectEpochRepository.html#method-RAVESubjectEpochRepository-set_epoch'><code>ravecore::RAVESubjectEpochRepository$set_epoch()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectEpochTimeFreqBaseRepository" data-id="mount_data"><a href='../../ravecore/html/RAVESubjectEpochTimeFreqBaseRepository.html#method-RAVESubjectEpochTimeFreqBaseRepository-mount_data'><code>ravecore::RAVESubjectEpochTimeFreqBaseRepository$mount_data()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectEpochTimeFreqCoefRepository-@marshal"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectEpochTimeFreqCoefRepository-@marshal}{}}}
\subsection{Method \code{@marshal()}}{
Internal method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectEpochTimeFreqCoefRepository$@marshal(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{internal arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectEpochTimeFreqCoefRepository-@unmarshal"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectEpochTimeFreqCoefRepository-@unmarshal}{}}}
\subsection{Method \code{@unmarshal()}}{
Internal method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectEpochTimeFreqCoefRepository$@unmarshal(object, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{object, ...}}{internal arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectEpochTimeFreqCoefRepository-new"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectEpochTimeFreqCoefRepository-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectEpochTimeFreqCoefRepository$new(
  subject,
  electrodes = NULL,
  reference_name = NULL,
  epoch_name = NULL,
  time_windows = NULL,
  stitch_events = NULL,
  ...,
  quiet = FALSE,
  repository_id = NULL,
  strict = TRUE,
  lazy_load = FALSE,
  .class = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subject}}{'RAVE' subject}

\item{\code{electrodes}}{string or integers indicating electrodes to load}

\item{\code{reference_name}}{name of the reference table}

\item{\code{epoch_name}}{name of the epoch trial table}

\item{\code{time_windows}}{numeric vector with even lengths, the time start
and end of the trials, for example, \code{c(-1, 2)} means load
1 second before the trial onset and 2 seconds after trial onset}

\item{\code{stitch_events}}{events where the \code{time_windows} is based;
default is trial onset (\code{NULL})}

\item{\code{...}}{passed to \code{\link{RAVESubjectEpochTimeFreqBaseRepository}} constructor}

\item{\code{quiet}}{see field \code{quiet}}

\item{\code{repository_id}}{see field \code{repository_id}}

\item{\code{strict}}{whether the mode should be strict; default is true and
errors out when subject is missing}

\item{\code{lazy_load}}{whether to delay \code{mount_data};
default is false}

\item{\code{.class}}{internally used, do not set, even if you know what this is}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectEpochTimeFreqCoefRepository-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectEpochTimeFreqCoefRepository-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectEpochTimeFreqCoefRepository$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
