% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper-indexes.R
\name{indexes_historical_data_get}
\alias{indexes_historical_data_get}
\title{Get historical data from B3 indexes}
\usage{
indexes_historical_data_get()
}
\value{
An \code{arrow_dplyr_query} or \code{ArrowObject}, representing a lazily evaluated query. The underlying data is not
collected until explicitly requested, allowing efficient manipulation of large datasets without immediate
memory usage.
To trigger evaluation and return the results as an R \code{tibble}, use \code{collect()}.
}
\description{
Fetches historical data from B3 indexes.
}
\examples{
\dontrun{
fetch_marketdata("b3-indexes-historical-data", index = "IBOV", year = 2001:2010)
indexes_historical_data_get() |>
 filter(index == "IBOV", refdate >= as.Date("2001-01-01"), refdate <= as.Date("2010-12-31"))
}

}
