% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisheye_to_equidistant.R
\name{fisheye_to_equidistant}
\alias{fisheye_to_equidistant}
\title{Fisheye to equidistant}
\usage{
fisheye_to_equidistant(r, z, a, m, radius = NULL, k = 1, p = 1, rmax = 100)
}
\arguments{
\item{r}{\link[terra:SpatRaster-class]{terra::SpatRaster} of one or more layers (e.g., RGB channels or
binary masks) in fisheye projection.}

\item{z}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=zenith_image]{zenith_image()}}.}

\item{a}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=azimuth_image]{azimuth_image()}}.}

\item{m}{logical \link[terra:SpatRaster-class]{terra::SpatRaster} with one layer. A binary mask with
\code{TRUE} for selected pixels.}

\item{radius}{numeric vector of length one. Radius (in pixels) of the
reprojected hemispherical image. Must be an integer value (no decimal
part). If \code{NULL} (default), it is set to \code{ncol(r) / 2}.}

\item{k, p, rmax}{numeric vector of length one. Parameters passed to
\code{\link[lidR:dtm_idw]{lidR::knnidw()}}: number of neighbors (\code{k}), inverse distance weighting
exponent (\code{p}), and maximum search radius (\code{rmax}) in units of the output
resolution.}
}
\value{
\link[terra:SpatRaster-class]{terra::SpatRaster} with the same number of layers as \code{r},
reprojected to equidistant projection with circular shape and radius
given by `radius
}
\description{
Reproject a hemispherical image from fisheye to equidistant projection
(also known as polar projection) to standardize its geometry for
subsequent analysis and comparison between images.
}
\details{
Pixel values and coordinates are treated as 3D points and reprojected
using Cartesian interpolation. Internally, this function uses
\code{\link[lidR:dtm_idw]{lidR::knnidw()}} as interpolation engine, so arguments \code{k}, \code{p}, and
\code{rmax} are passed to it without modification.
}
\examples{
\dontrun{
path <- system.file("external/APC_0836.jpg", package = "rcaiman")
caim <- read_caim(path)
calc_diameter(c(0.801, 0.178, -0.179), 1052, 86.2)
z <- zenith_image(2216,  c(0.801, 0.178, -0.179))
a <- azimuth_image(z)
zenith_colrow <- c(1063, 771)

caim <- expand_noncircular(caim, z, zenith_colrow)
m <- !is.na(caim$Red) & select_sky_region(z, 0, 86.2)
caim[!m] <- 0
m2 <- fisheye_to_equidistant(m, z, a, !is.na(z), radius = 600)
m2 <- binarize_with_thr(m2, 0.5) #to turn it logical
caim2[!m2] <- 0

plot(caim)
}
}
