% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-data.R
\name{check_data}
\alias{check_data}
\alias{clean_data}
\title{Check that data follows the expected structure}
\usage{
check_data(
  x,
  identifier = NULL,
  missing = NA,
  arg = rlang::caller_arg(x),
  call = rlang::caller_env()
)

clean_data(
  x,
  identifier = NULL,
  missing = NA,
  cleaned_qmatrix,
  arg_qmatrix = rlang::caller_arg(cleaned_qmatrix),
  valid_names = NULL,
  arg = rlang::caller_arg(x),
  call = rlang::caller_env()
)
}
\arguments{
\item{x}{The provided data to check.}

\item{identifier}{The provided respondent identifier, as a character string.
If no respondent identifier is present, the value should be \code{NULL} (the
default).}

\item{missing}{A expression specifying how missing data in \code{x} is coded
(e.g., \code{NA}, \code{"."}, \code{-99}). The default is \code{NA}.}

\item{arg}{The name of the argument.}

\item{call}{The call stack.}

\item{cleaned_qmatrix}{A cleaned Q-matrix, from \code{\link[=clean_qmatrix]{clean_qmatrix()}}.}

\item{arg_qmatrix}{A character string with the name of the argument used to
provide the Q-matrix.}

\item{valid_names}{An optional named vector of items (e.g., from a previous
call to \code{\link[=clean_data]{clean_data()}}). Used when checking new data objects for
consistency with items used to estimate a model.}
}
\value{
\code{check_data} returns the original data (if the checks pass) as a
\link[tibble:tibble-package]{tibble}, with missing data (i.e., \code{missing})
replaced with \code{NA}.

\code{clean_data} returns a list with five elements:
\itemize{
\item \code{clean_data}: The cleaned data
\item \code{item_identifier}: The real name of the item identifier
\item \code{item_names}: The real names of the items
\item \code{respondent_identifier}: The real name of the respondent identifier
\item \code{respondent_names}: The real names of the respondents
}
}
\description{
The data should be 1 row per respondent and 1 column per item, with an
optional additional column to store respondent identifiers. Each value of the
data should be a 0 or 1 to indicate the response to the item by the given
respondent. \code{\link[=clean_data]{clean_data()}} calls \code{\link[=check_data]{check_data()}} to verify the expected
structure, and then performs additional data manipulation to provide standard
conventions. See details for additional information.
}
\details{
In many instances, it's important to have standard conventions for a data
object so that we know what to expect (e.g., respondent and item identifiers,
data types). \code{\link[=clean_data]{clean_data()}} provides this standardization. Cleaned data is
returned in long format, with one row per response. Respondent and item
columns are encoded as factors, and responses are coerced to integer values.

To ensure downstream functions are able to identify the original
(pre-cleaned) values, \code{\link[=clean_data]{clean_data()}} returns a list that includes the cleaned
data, as well as metadata that includes look-ups from the original to cleaned
values.
}
\examples{
example_data <- tibble::tibble(person = 1:10,
                               item1 = sample(0:1, 10, replace = TRUE),
                               item2 = sample(0:1, 10, replace = TRUE),
                               item3 = sample(0:1, 10, replace = TRUE))
check_data(example_data, identifier = "person")
example_qmatrix <- tibble::tibble(item = paste0("item", 1:3),
                                  att_1 = c(0, 0, 1),
                                  att_2 = c(1, 1, 1))

example_data <- tibble::tibble(person = 1:10,
                               item1 = sample(0:1, 10, replace = TRUE),
                               item2 = sample(0:1, 10, replace = TRUE),
                               item3 = sample(0:1, 10, replace = TRUE))

qmatrix <- clean_qmatrix(example_qmatrix, identifier = "item")
clean_data(example_data, identifier = "person",
           cleaned_qmatrix = qmatrix)
}
