% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/escape.R
\name{re_escape}
\alias{re_escape}
\title{Escape special characters}
\usage{
re_escape(pattern)
}
\arguments{
\item{pattern}{A character vector where each element is a string in which special regex characters are to be escaped.}
}
\value{
A character vector of the same length as \code{pattern}.
}
\description{
\code{re_escape} escapes all special characters in a string. This function is useful when you want to treat a
string literally in a regular expression context, escaping characters that would otherwise be interpreted as special
regex operators.
}
\examples{
re_escape("a[bc].*d?")
re_escape(".^$|*+?{}[]()")
}
\seealso{
\href{https://docs.python.org/3/library/re.html#re.escape}{Python re.escape() documentation}
}
