% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdc_read.R
\name{pdc_read}
\alias{pdc_read}
\alias{pdc_datasets}
\alias{pdc_topics}
\title{Import datasets from the Provider Data Catalog (PDC)}
\usage{
pdc_read(datasetid, ...)

pdc_datasets(topics = NULL)

pdc_topics()
}
\arguments{
\item{datasetid}{A dataset identifier (e.g., from \code{pdc_datasets()})}

\item{...}{Additional arguments passed to \code{\link[readr:read_delim]{readr::read_csv()}}}

\item{topics}{A topic to list dataset metadata for (e.g., from \code{pdc_topics()})}
}
\value{
A character vector listing available data topics, or a \code{\link[tibble:tibble]{tibble::tibble()}} containing the requested data/metadata.
}
\description{
Explore and import datasets directly from the \href{https://data.cms.gov/provider-data/}{CMS Provider Data Catalog (PDC)}.
\itemize{
\item \code{pdc_topics()}: Retrieves the list of topics (subcategories) that data is available for
\item \code{pdc_datasets()}: Retrieves identifiers, names, descriptions, and other metadata associated with the datasets in the (optionally specified) \code{topics}
\item \code{pdc_read()}: Imports a full dataset for the given identifier (\code{datasetid}). These are found in \code{pdc_datasets()}.
}
}
\examples{
# 1. See list of available data topics
pdc_topics()


# 2. See list of datasets available for a topic
hospital_data <- pdc_datasets("Hospitals")
hospital_data

# Find a dataset you want
hospital_data |>
   dplyr::filter(
      stringr::str_detect(
         title,
         pattern = "(?i)readmission"
      )
   )


# 3. Use that data set ID to import
pdc_read("9n3s-kdb3")
}
