% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rect_pack.R
\name{pack_rects}
\alias{pack_rects}
\title{Pack rectangles into a box using the skyline algorithm}
\usage{
pack_rects(box_width, box_height, rect_widths, rect_heights)
}
\arguments{
\item{box_width, box_height}{dimensions of the box into which the 
rectangles will be packed. Integer values.}

\item{rect_widths, rect_heights}{widths and heights of the rectangles to pack.}
}
\value{
data.frame of packing information
\describe{
  \item{\code{idx}}{Integer index of rectangle in the input}
  \item{\code{w,h}}{Integer dimensions of each rectangle}
  \item{\code{packed}}{Logical: Was this rectangle packed into the box?}
  \item{\code{x,y}}{Integer coordinates of packing position of bottom-left of rectangle}
}
}
\description{
This implementation accepts only integer valued sizes and coordinates.
}
\examples{
# Pack 10 rectangles into a 25x25 box
# Note: All rectangles in the results have 'packed=TRUE' which
# means they all fit into the box
set.seed(1)
N <- 10
rect_widths  <- sample(N)
rect_heights <- sample(N)
pack_rects(box_width = 25, box_height = 25, rect_widths, rect_heights)
}
