% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_systems.R
\name{rl_systems}
\alias{rl_systems}
\title{IUCN Red List ecological systems}
\usage{
rl_systems(
  code = NULL,
  year_published = NULL,
  latest = NULL,
  possibly_extinct = NULL,
  possibly_extinct_in_the_wild = NULL,
  scope_code = NULL,
  page = 1
)
}
\arguments{
\item{code}{Character or Numeric. One or more system codes (e.g., "0", "1", "2").
Use \code{\link[=rl_systems]{rl_systems()}} to list available ecological systems.}

\item{year_published}{Optional. Single or numeric vector of years to filter assessments by publication year.}

\item{latest}{Optional. Logical. If \code{TRUE}, return only the latest assessment per species.}

\item{possibly_extinct}{Optional. Logical. Filter for species flagged as possibly extinct.}

\item{possibly_extinct_in_the_wild}{Optional. Logical. Filter for species possibly extinct in the wild.}

\item{scope_code}{Optional. Integer One or more scope codes to filter assessments.}

\item{page}{Optional. Integer vector. Specify one or more page numbers to fetch.
If \code{NULL} or \code{NA}, all pages will be fetched automatically.}
}
\value{
A tibble (class \code{tbl_df}, \code{tbl}, \code{data.frame}) where each column represents a unique API response JSON key.
If \code{code = NULL}, the tibble contains available ecological systems with columns such as code and description.
If \code{code} is provided, the tibble contains assessment data for the specified system(s), including description,
possible extinct in the wild, scientific name, latest, taxon details, and other relevant metadata.
}
\description{
Retrieve species assessments based on their ecological systems.
If \code{code = NULL}, it returns a list of available ecological systems.
If \code{code} is provided, it retrieves assessments for species in the specified system(s).
}
\examples{
\dontrun{
# List all ecological systems
rl_systems()

# Get terrestrial species assessments (code 0)
rl_systems(code = 0)

# Get marine species assessments published since 2021
rl_systems(
  code = "2",
  year_published = 2021:2023
)
}
}
