% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_checks.R
\name{refdb_check_tax_typo}
\alias{refdb_check_tax_typo}
\title{Check for typos in taxonomic names}
\usage{
refdb_check_tax_typo(x, tol = 1)
}
\arguments{
\item{x}{a reference database.}

\item{tol}{the edit distance below which two taxonomic names are reported.}
}
\value{
A list of two-columns tibbles reporting for each taxonomic level
the pairs of taxonomic names sharing the same upstream taxonomy and for
which the generalized Levenshtein (edit) distance is below
the \code{tol} value.
}
\description{
This function uses the generalized Levenshtein (edit) distance
to identify possible issue with taxonomic names.
}
\examples{
lib <- read.csv(system.file("extdata", "ephem.csv", package = "refdb"))
lib <- refdb_set_fields(lib,
                        taxonomy = c(family = "family_name",
                            genus = "genus_name",
                            species = "species_name"),
                        sequence = "DNA_seq",
                        marker = "marker")
refdb_check_tax_typo(lib)

}
