% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remode.R
\name{remode}
\alias{remode}
\title{Recursive Mode Detection for Distributions of Ordinal Data}
\usage{
remode(
  xt,
  alpha = 0.05,
  f_sign_test = c("bootstrap", "binomial", "fisher"),
  definition = c("shape_based", "peak_based"),
  check = FALSE,
  format_raw = FALSE,
  levels = seq(min(xt), max(xt)),
  n_boot = 10000,
  ...
)
}
\arguments{
\item{xt}{A numeric vector of ordinal data.}

\item{alpha}{The significance level for the chi-squared test. Default is 0.05. At each recursive step, \eqn{\alpha} is divided by the number of descriptive maxima in the distribution.}

\item{f_sign_test}{A character string or function specifying the statistical test to use for significance testing. Options are "bootstrap" (default), "binomial" (more efficient when N is large), "fisher" (exact fisher test) or a user-defined function. User-defined functions must include the following arguments: candidate, left_minimum, right_minimum, xt, alpha}

\item{definition}{Underlying modality definition. If "shape_based", the unifom distribution is classified as unimodal. If "peak_based", a uniform distribution is classified as having zero modes.}

\item{check}{A logical variable indicating whether to return input, test, and outcome of each recursive step of the algorithm. Default is FALSE.}

\item{format_raw}{A logical value indicating whether the input data (`xt`) is raw data. If TRUE, data will be converted to a frequency table inside the function. Default is FALSE.}

\item{levels}{A numeric vector specifying the categories of the (ordinal) distribution. Used for the factor conversion if `format_raw` is TRUE. Default is `seq(min(xt), max(xt))`.}

\item{n_boot}{Number of bootstrap samples. Only used if f_dign_test = "bootstrap".}

\item{...}{Additional arguments}
}
\value{
A list of class \code{remode_result} containing:
\describe{
  \item{nr_of_modes}{The number of modes identified in the data.}
  \item{mode_indeces}{The indices of the identified modes.}
  \item{p_values}{Max. p-value of each detected mode.}
  \item{approx_bayes_factors}{Approximated Bayes Factors, following Selke et al., 2001}
  \item{frequency_input_data}{Input data (as frequency table).}
  \item{alpha}{The original significance level.}
  \item{definition}{Chosen definition: shape based of peak based.}
}
}
\description{
Implementation of the recursive modality detection method ('remode') which detects modes in univariate distributions through recursive significance testing. 'remode' recursively tests whether the frequency of a local maximum significantly exceeds the frequencies of neighboring local minima on its left and right side.
}
\details{
The function recursively detects a mode candidate (highest frequency), tests whether its frequency significantly deviates from the lowest frequencies on both its left and right side. If significant, the candidate is classified as a mode. The function recursively processes the segments of the vector to the left and right of the mode candidate, applying the same procedure to identify additional modes.
}
\examples{
# Input data as frequencies
data <- c(80, 90, 110, 70, 90)
result <- remode(data)
print(result)
plot(result, xlab="This is my x-axis label", col="red", names=-2:2)

# Raw data input
x <- c(rep(1, 80), rep(2, 90), rep(3, 110), rep(4, 70), rep(5, 90))
result <- remode(x, format_raw = TRUE)
print(result)
plot(result, xlab="This is my x-axis label", col="red", names=-2:2)

}
