% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remode_stability.R
\name{remode_stability}
\alias{remode_stability}
\title{Barplot for 'remode' result}
\usage{
remode_stability(
  remode_result,
  iterations = 100,
  percentage_steps = 10,
  plot = TRUE
)
}
\arguments{
\item{remode_result}{A list of class `remode_result`, output of remode() function}

\item{iterations}{Numeric value specifying the number of random sub-samples to generate for each percentage step. Default is 100.}

\item{percentage_steps}{An integer specifying the number of percentage steps for data removal. Default is 20 (i.e. steps of 5).}

\item{plot}{Logical value indicating wether to plot the results. Default is TRUE.}
}
\value{
A list containing the stability analysis results.
}
\description{
remode_stability evaluates the stability of the mode estimation of the remode() function
by performing jacknife resampling. It generates
a series of jackknife resamples, calculates the mean and most frequent number of modes for
each sample, and determines the stability of the original modality estimate.
Stability is determined by te maximum percentage of data removal for which the
majority of iterations still find the original number of modes.
}
