% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDataTable.R
\name{addDataTable}
\alias{addDataTable}
\title{A wrap to \code{\link[openxlsx]{writeDataTable}}}
\usage{
addDataTable(
  wb,
  df,
  sheet,
  tableName,
  tableStyle = "TableStyleMedium1",
  withFilter = TRUE,
  firstActiveCol = NULL,
  ...
)
}
\arguments{
\item{wb}{a workbook object}

\item{df}{a data.frame}

\item{sheet}{the sheet name. If missing the name of the data.frame}

\item{tableName}{a name for the table in the excel document. If missing the name of the data.frame}

\item{tableStyle}{a tableStyle name}

\item{withFilter}{if TRUE the filter is included}

\item{firstActiveCol}{First column active on the the freeze panel}

\item{...}{other parameters for the \code{\link[openxlsx]{writeDataTable}}}
}
\value{
silently the wb
}
\description{
Include a \code{data.frame} into a workbook applying a tableStyle and
an auto width to the column. For better results you could setup
\code{options("openxlsx.minWidth" = 6)}
}
\examples{
\dontrun{
library(openxlxs)
options("openxlsx.minWidth" = 6)
wb <- createWorkbook(title = "Test addDataTable")
addDataTable(wb,iris)
saveWorkbook(wb, "test_addDataTable.xlsx")
}
}
