% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_helpers.R
\name{get_ith_local_neighbors}
\alias{get_ith_local_neighbors}
\title{A function to obtain the local neighbors based on dissimilarity
matrices from orthogonal projections.}
\usage{
get_ith_local_neighbors(
  ith_xr,
  ith_xu,
  ith_yr,
  ith_yu = NULL,
  diss_usage = "none",
  ith_neig_indices,
  k = NULL,
  k_diss = NULL,
  k_range = NULL,
  spike = NULL,
  diss_method,
  pc_selection,
  ith_group = NULL,
  center,
  scale,
  ...
)
}
\arguments{
\item{ith_xr}{the set of neighbors of a Xu observation found in Xr}

\item{ith_xu}{the Xu observation}

\item{ith_yr}{the response values of the set of neighbors of the Xu
observation found in Xr}

\item{ith_yu}{the response value of the xu observation}

\item{diss_usage}{a character string indicating if the dissimilarity data
will be used as predictors ("predictors") or not ("none").}

\item{ith_neig_indices}{a vector of the original indices of the Xr neighbors.}

\item{k}{the number of nearest neighbors to select from the already
identified neighbors}

\item{k_diss}{the distance threshold to select the neighbors from the already
identified neighbors}

\item{k_range}{a min and max  number of allowed neighbors when \code{k_diss}
is used}

\item{spike}{a vector with the indices of the observations forced to be
retained as neighbors. They have to be present in all the neighborhoods and
at the top of \code{neighbor_indices}.}

\item{diss_method}{the ortho_diss() method}

\item{pc_selection}{the pc_selection argument as in ortho_diss()}

\item{ith_group}{the vector containing the group labes of \code{ith_xr}.}

\item{center}{center the data in the local diss computation?}

\item{scale}{scale the data in the local diss computation?}
}
\value{
a list:
\itemize{
\item{ith_xr: the new Xr data of the neighbors for the ith observation (if
\code{diss_usage = "predictors"}, this data is combined with the local
dissmilarity scores of the neighbors of Xu)}
\item{ith_yr: the new Yr data of the neighbors for the ith observation}
\item{ith_xu: the ith Xu observation (if \code{diss_usage = "predictors"},
this data is combined with the local dissmilarity scores to its Xr neighbors}
\item{ith_yu: the ith Yu observation}
\item{ith_neigh_diss: the new dissimilarity scores of the neighbors for the ith
observation}
\item{ith_group: the group labels for the new ith_xr}
\item{n_k: the number of neighbors}
\item{ith_components: the number of components used}
}
}
\description{
internal function. This function is used to obtain the local
neighbors based on dissimilarity matrices from orthogonal projections. These
neighbors are obatin from an orthogonal projection on a set of precomputed
neighbors. This function is used internally by the mbl fucntion.
ortho_diss(, .local = TRUE) operates in the same way, however for mbl, it is
more efficient to do the re-search of the neighbors inside its main for loop
}
\author{
Leonardo Ramirez-Lopez
}
\keyword{internal}
