% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fft_spectrum.R
\name{fft_spectrum}
\alias{fft_spectrum}
\title{fft_spectrum}
\usage{
fft_spectrum(signal, f, f_out = 80, padding = 512)
}
\arguments{
\item{signal}{a speech signal}

\item{f}{sampling frequency}

\item{f_out}{output sampling frequency. Signal will be lowpass filtered at f_out/2}

\item{padding}{length to zero pad signal to. If signal is longer than padding, this will be increased.}
}
\value{
Returns a matrix with columns `freq` (frequency in Hz) and `pwr` (spectral power).
}
\description{
Calculates low frequency power spectrum of vocalic interval of speech signal. Following method of Tilsen & Johnson (2008)
}
\references{
Tilsen, S., & Johnson, K. (2008). Low-frequency Fourier analysis of speech rhythm. The Journal of the Acoustical Society of America, 124(2), EL34–EL39. doi:10.1121/1.2947626
}
\seealso{
fft_spectro
}
