% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invertList.R
\name{invertList}
\alias{invertList}
\title{Invert the names and elements of a list}
\usage{
invertList(inputList, simplify = FALSE)
}
\arguments{
\item{inputList}{a list, other classed (e.g. named vectors) will be converted to lists}

\item{simplify}{Logical, if yes and if no duplicated names, return a vector}
}
\value{
A list with values from the input becoming names and vice versa. When \code{simplify=TRUE} and there are no duplicated names, a named character vector is returned instead.
}
\description{
Invert the names and elements of a list
}
\examples{
myList <- list("A"=c("a", "alpha"), "B"=c("b", "Beta"), "C"="c")
invertList(myList)
invertList(myList, simplify=TRUE)
}
