% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ridge-fourier.R
\name{ridge_fourier_fit}
\alias{ridge_fourier_fit}
\title{Fourier expansion of a given curve}
\usage{
ridge_fourier_fit(curve, K = 15, norm_prop = 1, N = 1280, at2 = TRUE)
}
\arguments{
\item{curve}{points of the curve.}

\item{K}{number of terms in the Fourier expansion. Defaults to \code{15}.}

\item{norm_prop}{percentage of explained norm. Defaults to \code{1}.}

\item{N}{number of Gaussian quadrature points, passed to
\link[sphunif]{Gauss_Legen_nodes}. Defaults to \code{1280}.}

\item{at2}{do the \code{atan2} fit instead of the sine fit (only using
\eqn{S_m})? Defaults to \code{TRUE}. \code{at2 = FALSE} is not
recommended to use.}
}
\value{
The coefficients of the fit (see \code{\link{ridge_curve}}). A list
with entries:
\item{cos_a}{contains \eqn{a_0,a_1,\ldots,a_m}.}
\item{sin_b}{contains \eqn{b_1,\ldots,b_m}.}
}
\description{
Computation of the Fourier expansion coefficients of a
given curve.
}
\examples{
\donttest{
# Zero mean
ridge0 <- ridge_bvm(mu = c(0, 0), kappa = c(1, 2, -5), subint_1 = 5e2,
                    subint_2 = 5e2)
coefs <- ridge_fourier_fit(ridge0)
th <- seq(-pi, pi, l = 500)
plot(ridge0, xlim = c(-pi, pi), ylim = c(-pi, pi))
points(ridge_curve(th, mu = c(0, 0), coefs = coefs, at2 = TRUE), col = 3,
       cex = 0.5)

# Non-zero mean from a zero-mean ridge
mu <- c(1.4, 2)
ridge1 <- ridge_bvm(mu = mu, kappa = c(1, 2, -5), subint_1 = 5e2,
                    subint_2 = 5e2) # Just for plot
plot(ridge1, xlim = c(-pi, pi), ylim = c(-pi, pi))
points(mu[1], mu[2], col = 4, pch = "*", cex = 5)
points(ridge_curve(th, mu = mu, coefs = coefs), col = 3, cex = 0.5)

# Other zero-mean example
mu <- c(0, 0)
ridge <- ridge_bwc(mu = mu, xi = c(0.3, 0.5, 0.7), subint_1 = 5e2,
                   subint_2 = 5e2)
plot(ridge, xlim = c(-pi, pi), ylim = c(-pi, pi))
coefs <- ridge_fourier_fit(ridge)
points(ridge_curve(th, mu = mu, coefs = coefs), col = 4, cex = 0.5)

# Another zero-mean example
mu <- c(0, 0)
ridge <- ridge_bwc(mu = mu, xi = c(0.8, 0.1, 0.75), subint_1 = 5e2,
                   subint_2 = 5e2)
plot(ridge, xlim = c(-pi, pi), ylim = c(-pi, pi))
coefs <- ridge_fourier_fit(ridge)
points(ridge_curve(th, mu = mu, coefs = coefs), col = 4, cex = 0.5)}
}
