% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airm.R
\name{airm_unvec}
\alias{airm_unvec}
\title{Compute the Inverse Vectorization (AIRM)}
\usage{
airm_unvec(sigma, w)
}
\arguments{
\item{sigma}{A symmetric positive-definite matrix of class \code{dppMatrix}, representing the reference point.}

\item{w}{A numeric vector, representing the vectorized tangent image.}
}
\value{
A symmetric matrix of class \code{dspMatrix}, representing the tangent vector.
}
\description{
Converts a vector back into a tangent matrix relative to a reference point using AIRM.
}
\examples{
if (requireNamespace("Matrix", quietly = TRUE)) {
  library(Matrix)
  sigma <- diag(2) |>
    Matrix::nearPD() |>
    _$mat |>
    Matrix::pack()
  w <- c(1, sqrt(2), 2)
  airm_unvec(sigma, w)
}
}
