% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress_utils.R
\name{with_progress}
\alias{with_progress}
\title{Execute Expression with Progress Reporting}
\usage{
with_progress(expr, name = "Processing", enable = TRUE)
}
\arguments{
\item{expr}{Expression to evaluate}

\item{name}{Character string specifying the name of the operation (default: "Processing")}

\item{enable}{Logical indicating whether to enable progress reporting (default: TRUE).
If FALSE or if progressr is not available, the expression is executed without progress reporting.}
}
\value{
The result of evaluating \code{expr}.
}
\description{
Wrapper function that executes an expression with optional progress reporting.
Integrates with the progressr package when available.
}
\details{
This function provides a consistent interface for progress reporting across riemtan.
Progress handlers can be configured using \code{progressr::handlers()}.

When \code{enable = TRUE} and progressr is installed, users can see progress by calling:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{progressr::handlers("progress")  # or "txtprogressbar", "cli", etc.
}\if{html}{\out{</div>}}
}
\examples{
\dontrun{
# Enable progress reporting
progressr::handlers("progress")

# Use within a function
result <- with_progress({
  p <- progressr::progressor(steps = 10)
  lapply(1:10, function(i) {
    Sys.sleep(0.1)
    p()  # Signal progress
    i^2
  })
}, name = "Computing squares")
}

}
\seealso{
\code{\link[progressr:with_progress]{progressr::with_progress()}}, \code{\link[progressr:progressor]{progressr::progressor()}}
}
\keyword{internal}
