% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bioconductor_data.R
\name{bioconductor_reverse_deps}
\alias{bioconductor_reverse_deps}
\title{Find Bioconductor Package Reverse Dependencies}
\usage{
bioconductor_reverse_deps(
  pkg,
  which = "Imports",
  only.bioc = FALSE,
  version = BiocManager::version(),
  db = NULL,
  biocdb = NULL
)
}
\arguments{
\item{pkg}{Character string. The name of the package for which to find reverse dependencies.}

\item{which}{Character vector. The dependency categories to check.
One or more of \code{"Depends"}, \code{"Imports"}, \code{"LinkingTo"},
\code{"Suggests"}, or \code{"Enhances"}. Defaults to \code{"Imports"}.}

\item{only.bioc}{Logical. If \code{TRUE} (default), only reverse dependencies
that are Bioconductor packages are returned.}

\item{version}{Bioconductor version to use. Defaults to the current version.}

\item{db}{Optional. A pre-loaded package database to use for lookups.}

\item{biocdb}{Optional. A pre-loaded Bioconductor package database.}
}
\value{
A named list of reverse dependency package names.
}
\description{
This function returns the reverse dependencies for a given Bioconductor package.
}
\examples{
\dontrun{
# Get reverse Imports dependencies as a list:
bioconductor_reverse_deps("limma")

# Get multiple categories:
bioconductor_reverse_deps("limma", which = c("Depends", "Suggests"))
}
}
