% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting.R
\name{create_rd_table}
\alias{create_rd_table}
\title{Create Formatted Table of Risk Difference Results}
\usage{
create_rd_table(
  results,
  caption = "Risk Differences",
  include_model_type = FALSE,
  ...
)
}
\arguments{
\item{results}{Results tibble from calc_risk_diff()}

\item{caption}{Table caption (default: "Risk Differences")}

\item{include_model_type}{Whether to include model type column (default: FALSE)}

\item{...}{Additional arguments passed to kableExtra::kable()}
}
\value{
If kableExtra is available, returns a kable table object suitable for
rendering in R Markdown or HTML. The table includes formatted risk differences,
confidence intervals, and p-values with appropriate styling and footnotes.
If kableExtra is not available, returns a formatted tibble with the same
information in a basic data frame structure.
}
\description{
Creates a publication-ready table of risk difference results with
appropriate grouping and formatting. Requires the kableExtra package
for full functionality.
}
\examples{
data(cachar_sample)
results <- calc_risk_diff(cachar_sample, "abnormal_screen", "smoking")

# Basic table (works without kableExtra)
basic_table <- create_rd_table(results, caption = "Risk of Abnormal Cancer Screening")
print(basic_table)

# Enhanced table (requires kableExtra)
if (requireNamespace("kableExtra", quietly = TRUE)) {
  enhanced_table <- create_rd_table(
    results,
    caption = "Risk of Abnormal Cancer Screening by Smoking Status",
    include_model_type = TRUE
  )
  print(enhanced_table)
}

}
