% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iptw_diagnostics.R
\name{summary.riskdiff_iptw_result}
\alias{summary.riskdiff_iptw_result}
\title{Summary Method for IPTW Risk Difference Results}
\usage{
\method{summary}{riskdiff_iptw_result}(object, ...)
}
\arguments{
\item{object}{A riskdiff_iptw_result object}

\item{...}{Additional arguments (currently ignored)}
}
\value{
Invisibly returns the input object. Called primarily for side effects (printing summary).
}
\description{
Provides a comprehensive summary of IPTW risk difference analysis including
effect estimates, diagnostics, and interpretation guidance.
}
\examples{
data(cachar_sample)

rd_iptw <- calc_risk_diff_iptw(
  data = cachar_sample,
  outcome = "abnormal_screen",
  treatment = "areca_nut",
  covariates = c("age", "sex", "residence", "smoking")
)

summary(rd_iptw)

}
