% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_regarima.R
\name{add_outlier}
\alias{add_outlier}
\alias{remove_outlier}
\alias{add_ramp}
\alias{remove_ramp}
\title{Manage Outliers/Ramps in Specification}
\usage{
add_outlier(x, type, date, name = sprintf("\%s (\%s)", type, date), coef = 0)

remove_outlier(x, type = NULL, date = NULL, name = NULL)

add_ramp(x, start, end, name = sprintf("rp.\%s - \%s", start, end), coef = 0)

remove_ramp(x, start = NULL, end = NULL, name = NULL)
}
\arguments{
\item{x}{the specification to customize, must be a "SPEC" class object (see
details).}

\item{type, date}{type and date of the outliers. Possible \code{type} are:
\code{"AO"} = additive, \code{"LS"} = level shift, \code{"TC"} = transitory
change and \code{"SO"} = seasonal outlier.}

\item{name}{the name of the variable (to format print).}

\item{coef}{the coefficient if needs to be fixed. If equal to 0 the
outliers/ramps coefficients are estimated.}

\item{start, end}{dates of the ramp regressor.}
}
\value{
The modified specification (with/without outliers or ramp)
}
\description{
Generic function to add outliers or Ramp regressors (\code{add_outlier()} and
\code{add_ramp()}) to a specification or to remove them
(\code{remove_outlier()} and \code{remove_ramp()}).
}
\details{
\code{x} specification parameter must be a JD3_X13_SPEC" class object
generated with \code{rjd3x13::x13_spec()} (or "JD3_REGARIMA_SPEC" generated
with \code{rjd3x13::spec_regarima()} or "JD3_TRAMOSEATS_SPEC" generated with
\code{rjd3tramoseats::spec_tramoseats()} or "JD3_TRAMO_SPEC" generated with
\code{rjd3tramoseats::spec_tramo()}). If a Seasonal adjustment process is
performed, each type of Outlier will be allocated to a pre-defined component
after the decomposition: "AO" and "TC" to the irregular, "LS" and Ramps to
the trend.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}

init_spec <- x13_spec_default

# Adding outlier on year 2012
new_spec <- add_outlier(init_spec, type = "AO", date = "2012-01-01")
# Removing outlier on year 2012
new_spec <- remove_outlier(new_spec, type = "AO", date = "2012-01-01")

# Adding ramp on year 2012
new_spec2 <- add_ramp(init_spec, start = "2012-01-01", end = "2012-12-01")
# Removing ramp on year 2012
new_spec2 <- remove_ramp(new_spec2, start = "2012-01-01", end = "2012-12-01")
\dontshow{\}) # examplesIf}
}
\references{
More information on outliers and other auxiliary variables in JDemetra+ online documentation:
\url{https://jdemetra-new-documentation.netlify.app/}
}
\seealso{
\code{\link{add_usrdefvar}}, \code{\link{intervention_variable}}
}
