% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_regarima.R
\name{set_estimate}
\alias{set_estimate}
\title{Set Numeric Estimation Parameters and Modelling Span}
\usage{
set_estimate(
  x,
  type = c(NA, "All", "From", "To", "Between", "Last", "First", "Excluding"),
  d0 = NULL,
  d1 = NULL,
  n0 = 0,
  n1 = 0,
  tol = NA,
  exact.ml = NA,
  unit.root.limit = NA
)
}
\arguments{
\item{x}{the specification to customize, must be a "SPEC" class object (see
details).}

\item{type, d0, d1, n0, n1}{parameters to specify the sub-span .

\code{d0} and \code{d1} characters in the format "YYYY-MM-DD" to specify
first/last date of the span when \code{type} equals to \code{"From"},
\code{"To"} or \code{"Between"}.
Date corresponding to \code{d0} will be included in the sub-span
Date corresponding to \code{d1} will be excluded from the sub span

\code{n0} and \code{n1} numeric to specify the number of periods at the
beginning/end of the series to be used for defining the sub-span
(\code{type} equals to \code{"First"}, \code{"Last"}) or to exclude
(\code{type} equals to \code{"Excluding"}).}

\item{tol}{a numeric, convergence tolerance. The absolute changes in the
log-likelihood function are compared to this value to check for the
convergence of the estimation iterations. (The default setting is 0.0000001)}

\item{exact.ml}{(TRAMO specific) \code{logical}, the exact maximum likelihood
estimation. If \code{TRUE}, the program performs an exact maximum likelihood
estimation. If \code{FASLE}, the Unconditional Least Squares method is used.
(Default=TRUE)}

\item{unit.root.limit}{(TRAMO specific) \code{numeric}, the final unit root
limit. The threshold value for the final unit root test for identification of
differencing orders. If the magnitude of an AR root for the final model is
smaller than this number, then a unit root is assumed, the order of the AR
polynomial is reduced by one and the appropriate order of the differencing
(non-seasonal, seasonal) is increased.(Default value: 0.96)}
}
\value{
The modified specification (with new estimation parameters)
}
\description{
Function allowing to define numeric boundaries for estimation and to define
a sub-span on which reg-arima (tramo) modelling will be performed
(pre-processing step)
}
\details{
\code{x} specification parameter must be a JD3_X13_SPEC" class object
generated with \code{rjd3x13::x13_spec()} (or "JD3_REGARIMA_SPEC" generated
with \code{rjd3x13::spec_regarima()} or "JD3_TRAMOSEATS_SPEC" generated with
\code{rjd3tramoseats::spec_tramoseats()} or "JD3_TRAMO_SPEC" generated with
\code{rjd3tramoseats::spec_tramo()}).
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
# Customize a default specification
init_spec <- tramoseats_spec_default
new_spec <- set_estimate(
    x = init_spec,
    type = "From",
    d0 = "2012-01-01",
    tol = 0.0000002,
    exact.ml = FALSE,
    unit.root.limit = 0.98
)
\dontshow{\}) # examplesIf}
}
\references{
More in JDemetra+ online documentation:
\url{https://jdemetra-new-documentation.netlify.app/}
}
\seealso{
\code{\link{set_basic}}, \code{\link{set_arima}}
}
