/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13.diagnostics;

import java.util.Collections;
import java.util.List;
import jdplus.toolkit.base.api.processing.Diagnostics;
import jdplus.toolkit.base.api.processing.ProcQuality;
import jdplus.x13.base.core.x13.Mstatistics;
import jdplus.x13.base.core.x13.X13Results;
import jdplus.x13.base.core.x13.diagnostics.MDiagnosticsConfiguration;
import jdplus.x13.base.core.x13.diagnostics.MDiagnosticsFactory;

public class MDiagnostics
implements Diagnostics {
    public double[] stats;
    private double bad = 1.0;
    private double severe = 2.0;

    public static MDiagnostics of(MDiagnosticsConfiguration config, X13Results rslts) {
        try {
            Mstatistics stats = rslts.getDiagnostics().getMstatistics();
            return new MDiagnostics(config, stats);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private MDiagnostics(MDiagnosticsConfiguration config, Mstatistics mstats) {
        this.bad = config.getBadThreshold();
        this.severe = config.getSevereThreshold();
        int nm = mstats.getMCount();
        this.stats = new double[nm + 2];
        for (int i = 0; i < nm; ++i) {
            this.stats[i] = mstats.getM(i + 1);
        }
        this.stats[nm++] = mstats.getQ();
        this.stats[nm] = mstats.getQm2();
    }

    public String getName() {
        return "M-Statistics";
    }

    public List<String> getTests() {
        return MDiagnosticsFactory.ALL;
    }

    public ProcQuality getDiagnostic(String test) {
        double pval = this.getValue(test);
        if (Double.isNaN(pval)) {
            return ProcQuality.Undefined;
        }
        if (pval >= this.severe) {
            return ProcQuality.Severe;
        }
        if (pval >= this.bad) {
            return ProcQuality.Bad;
        }
        return ProcQuality.Good;
    }

    public double getValue(String test) {
        double val = Double.NaN;
        if (test.equals("q")) {
            val = this.stats[this.stats.length - 2];
        }
        if (test.equals("q2")) {
            val = this.stats[this.stats.length - 1];
        }
        return val;
    }

    public List<String> getWarnings() {
        return Collections.emptyList();
    }

    public double getBadThreshold() {
        return this.bad;
    }

    public double getSevereThreshold() {
        return this.severe;
    }

    public double[] getMStatistics() {
        return this.stats;
    }
}

