% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Show-Result.R
\name{methodsrobustbetareg}
\alias{methodsrobustbetareg}
\alias{summary.robustbetareg}
\alias{coef.robustbetareg}
\alias{print.summary.robustbetareg}
\title{Methods for robustbetareg Objects}
\usage{
\method{summary}{robustbetareg}(object, type = "sweighted2", ...)

\method{coef}{robustbetareg}(object, model = c("full", "mean", "precision"), ...)

\method{print}{summary.robustbetareg}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{object, x}{fitted model of class \code{robustbetareg}.}

\item{type}{character specifying the type of residuals to be included in the
summary output, see \code{\link{residuals.robustbetareg}}.}

\item{...}{currently not used.}

\item{model}{character specifying for which component of the model the
coefficients should be extracted.}

\item{digits}{the number of significant digits to use when printing.}
}
\value{
\code{methodsrobustbetareg} returns different outputs for objects of
    class \code{robustbetareg}, depending on the used method.
}
\description{
Some S3 methods for objects of class "\code{robustbetareg}".
}
\details{
A set of methods for fitted model objects of class \code{robustbetareg},
     including methods to the generic functions \code{\link{print}} and
     \code{\link{summary}}, which print the estimated coefficients along with
     some further information.
}
\examples{
\donttest{
data("HIC", package="robustbetareg")
fit=robustbetareg(HIC~URB+GDP|1,data=HIC,alpha=0.06)
summary(fit)
coef(fit)
}

}
\seealso{
\code{\link{robustbetareg}}
}
