% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table_transform.R
\name{add_custom_column}
\alias{add_custom_column}
\alias{add_custom_column.flat_table}
\title{Add custom column}
\usage{
add_custom_column(ft, name, definition)

\method{add_custom_column}{flat_table}(ft, name = NULL, definition)
}
\arguments{
\item{ft}{A \code{flat_table} object.}

\item{name}{A string, new column name.}

\item{definition}{A function that returns a table column.}
}
\value{
A \code{flat_table} object.
}
\description{
Add a column returned by a function that takes the data of the flat table as
a parameter.
}
\examples{

f <- function(table) {
  paste0(table$City, ' - ', table$State)
}

ft <- flat_table('ft_num', ft_num) |>
  add_custom_column(name = 'city_state', definition = f)

}
\seealso{
\code{\link{flat_table}}

Other flat table transformation functions: 
\code{\link{remove_instances_without_measures}()},
\code{\link{replace_empty_values}()},
\code{\link{replace_string}()},
\code{\link{replace_unknown_values}()},
\code{\link{select_attributes}()},
\code{\link{select_instances}()},
\code{\link{select_instances_by_comparison}()},
\code{\link{select_measures}()},
\code{\link{separate_measures}()},
\code{\link{transform_attribute_format}()},
\code{\link{transform_from_values}()},
\code{\link{transform_to_attribute}()},
\code{\link{transform_to_measure}()},
\code{\link{transform_to_values}()}
}
\concept{flat table transformation functions}
