% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_query.R
\name{select_dimension}
\alias{select_dimension}
\alias{select_dimension.star_query}
\title{Select dimension}
\usage{
select_dimension(sq, name, attributes)

\method{select_dimension}{star_query}(sq, name = NULL, attributes = NULL)
}
\arguments{
\item{sq}{A \code{star_query} object.}

\item{name}{A string, name of the dimension.}

\item{attributes}{A vector of attribute names.}
}
\value{
A \code{star_query} object.
}
\description{
To add a dimension in a \code{star_query} object, we have to define its name and a
subset of the dimension attributes. If only the name of the dimension is
indicated, it is considered that all its attributes should be added.
}
\examples{

sq <- mrs_db |>
  star_query() |>
  select_dimension(name = "where",
                  attributes = c("city", "state")) |>
  select_dimension(name = "when")

}
\seealso{
Other query functions: 
\code{\link{as_GeoPackage}()},
\code{\link{as_geolayer}()},
\code{\link{filter_dimension}()},
\code{\link{get_layer}()},
\code{\link{get_variable_description}()},
\code{\link{get_variables}()},
\code{\link{run_query}()},
\code{\link{select_fact}()},
\code{\link{set_layer}()},
\code{\link{set_variables}()},
\code{\link{star_query}()}
}
\concept{query functions}
