% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.RollingLDA.R
\name{as.RollingLDA}
\alias{as.RollingLDA}
\alias{is.RollingLDA}
\title{RollingLDA Object}
\usage{
as.RollingLDA(x, id, lda, docs, dates, vocab, chunks, param)

is.RollingLDA(obj, verbose = FALSE)
}
\arguments{
\item{x}{[\code{named list}]\cr
\code{\link{RollingLDA}} object. Alternatively each element can be passed for
individual results. Individually set elements overwrite elements from \code{x}.}

\item{id}{[\code{character(1)}]\cr
Name for the computation/model.}

\item{lda}{[\code{named list}]\cr
\code{\link[ldaPrototype]{LDA}} object.}

\item{docs}{[\code{named list}]\cr
Texts in a preprocessed format. See \code{\link[tosca]{LDAprep}}.}

\item{dates}{[\code{(un)named Date}]\cr
Dates of the texts. If unnamed, it must match the order of docs.}

\item{vocab}{[\code{character}]\cr
Vocabularies.}

\item{chunks}{[\code{data.table}]\cr
with specifications for each model chunk
\describe{
  \item{\code{chunk.id}}{[\code{integer}] Index counting up starting with \code{0}.}
  \item{\code{start.date}}{[\code{Date}] Minimum of each chunk's dates.}
  \item{\code{end.date}}{[\code{Date}] Maximum of each chunk's dates.}
  \item{\code{memory}}{[\code{Date}] Date from which texts are considered as memory.}
  \item{\code{n}}{[\code{integer}] Number of fitted texts.}
  \item{\code{n.dicsarded}}{[\code{integer}] Number of lost texts through preprocessing.}
  \item{\code{n.memory}}{[\code{integer}] Number of texts considered as memory.}
  \item{\code{n.vocab}}{[\code{integer}] Number of vocabularies (monotonously increasing).}
}
If not passed, \code{lda} is interpreted as initialization chunk.}

\item{param}{[\code{named list(4)}]\cr
Parameters of the object, i.e. parameters for future updates fitted on the
to be created model. List always should contain names "vocab.abs", "vocab.rel",
"vocab.fallback" and "doc.abs".}

\item{obj}{[\code{R} object]\cr
Object to test.}

\item{verbose}{[\code{logical(1)}]\cr
Should test information be given in the console?}
}
\value{
[\code{named list}] \code{\link{RollingLDA}} object.
}
\description{
Constructor for RollingLDA objects used in this package.
The function may be useful to create a RollingLDA object out of a standard
\code{\link[ldaPrototype]{LDA}} object to use it as initial model and
update it using \code{\link{updateRollingLDA}}.
}
\details{
If you call \code{as.RollingLDA} on an object \code{x} which already is of
the structure of an \code{RollingLDA} object (in particular a \code{RollingLDA}
object itself), the additional arguments \code{id, param, ...}
may be used to override the specific elements.
}
\examples{
roll_lda = RollingLDA(texts = economy_texts,
                      dates = economy_dates,
                      chunks = "quarter",
                      memory = "3 quarter",
                      init = "2008-07-03",
                      K = 10,
                      type = "lda")

is.RollingLDA(roll_lda, verbose = TRUE)
getID(roll_lda)
roll_lda = as.RollingLDA(roll_lda, id = "newID")
getID(roll_lda)

}
\seealso{
Other RollingLDA functions: 
\code{\link{RollingLDA}()},
\code{\link{getChunks}()},
\code{\link{updateRollingLDA}()}
}
\concept{RollingLDA functions}
