% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rosario.R
\name{rosario_sample}
\alias{rosario_sample}
\title{ROSARIO randomization of an assemblage matrix}
\usage{
rosario_sample(mat)
}
\arguments{
\item{mat}{Numeric matrix with biological identities in rows and ordered
time intervals in columns.}
}
\value{
A numeric matrix of the same dimension as \code{mat}, randomized row-wise.
}
\description{
Randomly permutes each row by a uniform cyclic shift of its columns and,
with probability 0.5, reverses the order (mirror image). This kind of
permutations preserves each biological identity's temporal autocorrelation
structure and niche breadth while randomizing location within the cycle.
}
\examples{
rosario_sample(ex1)
}
\seealso{
\code{\link[=rosario]{rosario()}}, \code{\link[=vec_permutation]{vec_permutation()}}
}
