% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temp_overlap.R
\name{temp_overlap}
\alias{temp_overlap}
\title{Mean concurrent temporal niche overlap}
\usage{
temp_overlap(mat, method = c("pianka", "czekanowski"))
}
\arguments{
\item{mat}{Numeric matrix (rows = biological identities, columns = ordered time intervals).}

\item{method}{Overlap index to use: \code{"pianka"} or \code{"czekanowski"}.}
}
\value{
A single numeric value (named by the method) equal to the mean of
the lower triangle of the pairwise overlap matrix.
}
\description{
Computes the \strong{mean} of all pairwise overlaps among rows (biological
identities) using the chosen index.
}
\details{
For \code{"czekanowski"}, rows are automatically rescaled to proportions.
}
\examples{
temp_overlap(ex1, method = "pianka")
temp_overlap(rescale_matrix(ex1), method = "czekanowski")
}
\seealso{
\code{\link[=temp_overlap_matrix]{temp_overlap_matrix()}}, \code{\link[=get_null_model]{get_null_model()}}
}
