% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_core_plot.R
\name{plotTypes}
\alias{plotTypes}
\alias{getAvailablePlotTypes}
\title{Get Available Plot Types}
\usage{
plotTypes(
  obj,
  output = c("numeric", "caption", "numcap", "capnum"),
  numberInCaptionEnabled = FALSE
)

getAvailablePlotTypes(
  obj,
  output = c("numeric", "caption", "numcap", "capnum"),
  numberInCaptionEnabled = FALSE
)
}
\arguments{
\item{obj}{The object for which the plot types shall be identified, e.g. produced by
\code{\link[=getDesignGroupSequential]{getDesignGroupSequential()}} or \code{\link[=getSampleSizeMeans]{getSampleSizeMeans()}}.}

\item{output}{The output type. Can be one of \code{c("numeric", "caption", "numcap", "capnum")}.}

\item{numberInCaptionEnabled}{If \code{TRUE}, the number will be added to the
caption, default is \code{FALSE}.}
}
\value{
Returns a list if \code{option} is either \code{capnum} or \code{numcap}
or returns a vector that is of  character type for \code{option=caption} or
of numeric type for \code{option=numeric}.
}
\description{
Function to identify the available plot types of an object.
}
\details{
\code{plotTypes} and \code{getAvailablePlotTypes()} are equivalent, i.e.,
\code{plotTypes} is a short form of \code{getAvailablePlotTypes()}.

\code{output}:
\enumerate{
\item \code{numeric}: numeric output
\item \code{caption}: caption as character output
\item \code{numcap}:  list with number and caption
\item \code{capnum}:  list with caption and number
}
}
\examples{
\dontrun{
design <- getDesignInverseNormal(kMax = 2)
getAvailablePlotTypes(design, "numeric")
plotTypes(design, "caption")
getAvailablePlotTypes(design, "numcap")
plotTypes(design, "capnum")
}

}
