% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registration.R
\name{ants_apply_transforms_to_points}
\alias{ants_apply_transforms_to_points}
\title{Apply a transform list to map points from one domain to another}
\usage{
ants_apply_transforms_to_points(
  dim,
  points,
  transformlist,
  whichtoinvert = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{dim}{dimensions of the transformation}

\item{points}{data frame containing columns \code{'x'}, \code{'y'},
\code{'z'}, \code{'t'} (depending on \code{dim})}

\item{transformlist}{list of strings (path to transforms) generated by
\code{\link{ants_registration}} where each transform is a file name}

\item{whichtoinvert}{either \code{NULL}, \code{None} ('Python'), or a vector
of logical with same length as \code{transformlist}; print
\code{ants$apply_transforms_to_points} to see detailed descriptions}

\item{verbose}{whether to verbose application of transform}

\item{...}{ignored}
}
\value{
Transformed points in data frame (R object)
}
\description{
See \code{ants$apply_transforms_to_points} for more details. Please note
point mapping goes the opposite direction of image mapping (see
\code{\link{ants_apply_transforms}}), for both reasons of convention and
engineering.
}
\examples{

if(interactive() && ants_available()) {
  ants <- load_ants()
  fixed <- as_ANTsImage( ants$get_ants_data('r16') )
  moving <- as_ANTsImage( ants$get_ants_data('r27') )

  reg <- ants_registration(
    fixed = fixed, moving = moving,
    type_of_transform = "antsRegistrationSyNRepro[a]")

  pts <- data.frame(
    x = c(128, 127),
    y = c(101, 111)
  )

  ptsw = ants_apply_transforms_to_points(2, pts, reg$fwdtransforms)
  ptsw
}

}
\seealso{
\code{print(ants$apply_transforms_to_points)}
}
