% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{plot.rq.pen.seq.cv}
\alias{plot.rq.pen.seq.cv}
\title{Plots cross validation results from a rq.pen.seq.cv object}
\usage{
\method{plot}{rq.pen.seq.cv}(
  x,
  septau = ifelse(x$fit$penalty != "gq", TRUE, FALSE),
  tau = NULL,
  logLambda = TRUE,
  main = NULL,
  ...
)
}
\arguments{
\item{x}{The rq.pen.seq.cv object}

\item{septau}{If set to true then optimal tuning parameters are selected seperately for each quantile and there will be a different plot for each quanitle.}

\item{tau}{Quantiles of interest.}

\item{logLambda}{Whether log(lambda) is used for the x-axis}

\item{main}{Title to the plot}

\item{...}{Additional parameters sent to the plot function.}
}
\value{
Plots of the cross validation results by lambda.
}
\description{
Provides plots of cross-validation results by lambda. If septau is set to TRUE then plots the cross-validation results for each quantile. If septau is set to FALSE
then provides one plot for cross-validation results across all quantiles.
}
\examples{
set.seed(1)
x <- matrix(rnorm(100*8,sd=1),ncol=8)
y <- 1 + x[,1] + 3*x[,3] - x[,8] + rt(100,3)
m1 <- rq.pen.cv(x,y,tau=c(.1,.3,.7))
plot(m1)
plot(m1,septau=FALSE)
}
\author{
Ben Sherwood, \email{ben.sherwood@ku.edu}
}
