% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tasks.R
\name{tasks}
\alias{tasks}
\title{List Tasks}
\usage{
tasks(account = NULL, server = NULL)
}
\arguments{
\item{account, server}{Uniquely identify a remote server with either your
user \code{account}, the \code{server} name, or both. If neither are supplied, and
there are multiple options, you'll be prompted to pick one.

Use \code{\link[=accounts]{accounts()}} to see the full list of available options.}
}
\value{
Returns a data frame with the following columns:
\tabular{ll}{
\code{id} \tab Task id \cr
\code{action} \tab Task action\cr
\code{status} \tab Current task status\cr
\code{created_time} \tab Task creation time\cr
\code{finished_time} \tab Task finished time\cr
}
}
\description{
List Tasks

Supported servers: ShinyApps servers
}
\note{
This function works only with shinyapps.io.
}
\examples{
\dontrun{

# list tasks for the default account
tasks()

}
}
\seealso{
\code{\link[=taskLog]{taskLog()}}
}
