% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/article_retrieval.R
\name{article_retrieval}
\alias{article_retrieval}
\title{ScienceDirect Article Retrieval}
\usage{
article_retrieval(
  id,
  view = c("META", "META_ABS", "META_ABS_REF", "FULL", "REF", "ENTITLED"),
  identifier = c("scopus_id", "eid", "doi", "pii", "pubmed_id"),
  http_end = NULL,
  ...
)
}
\arguments{
\item{id}{Identifier for article}

\item{view}{Which view to see.  See
\url{https://dev.elsevier.com/guides/ArticleRetrievalViews.htm}}

\item{identifier}{Type of identifier to use}

\item{http_end}{any additional end to http statement.
See \code{\link{generic_elsevier_api}}}

\item{...}{Arguments to be passed to \code{\link{generic_elsevier_api}}}
}
\value{
List of elements, similar to \code{\link{generic_elsevier_api}}
}
\description{
This function wraps \code{\link{generic_elsevier_api}} to give a
retrieval of an article from the Elsevier Article Retrieval API
}
\examples{
api_key = get_api_key(NULL, error = FALSE)
if (!is.null(api_key)){
    x = article_retrieval("S1053811915002700", identifier = "pii",
    verbose = FALSE, view = "FULL")
    gen = x$content$`full-text-retrieval-response`
    ot = gen$originalText
} else {
 x = article_retrieval("S1053811915002700",
   identifier = "pii",
   api_key_error = FALSE)
}
}
\seealso{
\code{\link{generic_elsevier_api}}
}
