% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsurv.R
\name{qsurv}
\alias{qsurv}
\title{Generic quantile function}
\usage{
qsurv(p, baseline, package = NULL, ...)
}
\arguments{
\item{p}{vector of quantiles associated with the right tail area of the baseline survival distribution.}

\item{baseline}{the name of the baseline distribution.}

\item{package}{the name of the package where the baseline distribution is implemented. It ensures that the right quantile function from the right package is found, regardless of the current R search path.}

\item{...}{further arguments passed to other methods.}
}
\value{
a vector of quantiles.
}
\description{
Generic quantile function used internally to simulating from an arbitrary baseline survival distribution.
}
\examples{

library(rsurv)
set.seed(1234567890)


u <- sort(runif(5))
x1 <- qexp(u, rate = 1, lower.tail = FALSE)
x2 <- qsurv(u, baseline = "exp", rate = 1)
x3 <- qsurv(u, baseline = "exp", rate = 1, package = "stats")
x4 <- qsurv(u, baseline = "gengamma.orig", shape=1, scale=1, k=1, package = "flexsurv")

cbind(x1, x2, x3, x4)

}
