% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projectId.R
\name{projectId}
\alias{projectId}
\alias{projectId,character-method}
\alias{projectId,Project-method}
\alias{projectId,Scenario-method}
\alias{projectId,Folder-method}
\alias{projectId,Chart-method}
\title{Retrieves projectId of SyncroSim Project, Scenario, Folder, or Chart}
\usage{
projectId(ssimObject)

\S4method{projectId}{character}(ssimObject)

\S4method{projectId}{Project}(ssimObject)

\S4method{projectId}{Scenario}(ssimObject)

\S4method{projectId}{Folder}(ssimObject)

\S4method{projectId}{Chart}(ssimObject)
}
\arguments{
\item{ssimObject}{\code{\link{Scenario-class}}, \code{\link{Project-class}},
\code{\link{Folder-class}}, or \code{\link{Chart-class}} object}
}
\value{
An integer: project id.
}
\description{
Retrieves the projectId of a SyncroSim \code{\link{Project-class}},
\code{\link{Scenario-class}}, \code{\link{Folder-class}} or \code{\link{Chart-class}}.
}
\examples{
\dontrun{
# Set the file path and name of the new SsimLibrary
myLibraryName <- file.path(tempdir(),"testlib")

# Set the SyncroSim Session, SsimLibrary, Project, and Scenario
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession) 
myProject <- project(myLibrary, project = "Definitions")
myScenario <- scenario(myProject, scenario = "My Scenario")

# Get Project ID for SyncroSim Project and Scenario
projectId(myProject)
projectId(myScenario)
}

}
