% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay_calculator.R
\name{delay_calculator}
\alias{delay_calculator}
\title{Calculate the total infectiousness at each observed time point.}
\usage{
delay_calculator(
  observed_counts,
  x = NULL,
  dist_gamma = c(2.5, 2.5),
  delay_distn = NULL,
  delay_distn_periodicity = NULL,
  xout = x
)
}
\arguments{
\item{observed_counts}{vector of the observed daily infection counts}

\item{x}{a vector of positions at which the counts have been observed. In an
ideal case, we would observe data at regular intervals (e.g. daily or
weekly) but this may not always be the case. May be numeric or Date.}

\item{dist_gamma}{Vector of length 2. These are the shape and scale for the
assumed serial interval distribution. Roughly, this distribution describes
the probability of an infectious individual infecting someone else after
some period of time after having become infectious.
As in most literature, we assume that this interval follows a gamma
distribution with some shape and scale.}

\item{delay_distn}{in the case of a non-gamma delay distribution,
a vector or matrix (or \code{Matrix::Matrix()}) of delay probabilities may be
passed here. For a vector, these will be coerced
to sum to 1, and padded with 0 in the right tail if necessary. If a
time-varying delay matrix, it must be lower-triangular. Each row will be
silently coerced to sum to 1. See also \code{vignette("delay-distributions")}.}

\item{delay_distn_periodicity}{Controls the relationship between the spacing
of the computed delay distribution and the spacing of \code{x}. In the default
case, \code{x} would be regular on the sequence \code{1:length(observed_cases)},
and this would
be 1. But if \code{x} is a \code{Date} object or spaced irregularly, the relationship
becomes more complicated. For example, weekly data when \code{x} is a date in
the form \code{YYYY-MM-DD} requires specifying \code{delay_distn_periodicity = "1 week"}.
Or if \code{observed_cases} were reported on Monday, Wednesday, and Friday,
then \code{delay_distn_periodicity = "1 day"} would be most appropriate.}

\item{xout}{a vector of positions at which the results should be returned.
By default, this will be the same as \code{x}, but in the case that observations
are unequally spaced, alternatives may be desired. Note that \code{xout} must
satisfy \code{min(x) <= min(xout)} and \code{max(x) >= max(xout)}.}
}
\value{
A vector containing the total infectiousness at each
point \code{xout}.
}
\description{
The total infectiousness at each observed time point is calculated
by \eqn{\sum_{s=1}^t I_{t-s}w_s}, where \eqn{I} denotes the vector containing
observed incidence, and \eqn{w} denotes the generation interval
distribution. Typically, the generation interval is challenging to estimate
from data, so the serial interval is used instead. The serial interval
distribution expresses the probability
of a secondary infection caused by a primary infection which occurred \eqn{s}
days earlier.
}
\examples{
delay_calculator(c(3, 2, 5, 3, 1), dist_gamma = c(2.5, 2.5))
}
