% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cubist_rules.R
\name{committees}
\alias{committees}
\alias{max_rules}
\title{Parameter functions for Cubist models}
\usage{
committees(range = c(1L, 100L), trans = NULL)

max_rules(range = c(1L, 500L), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\value{
A function with classes "quant_param" and "param"
}
\description{
Committee-based models enact a boosting-like procedure to produce ensembles.
\code{committees} parameter is for the number of models in the ensembles while
\code{max_rules} can be used to limit the number of possible rules.
}
\examples{
committees()
committees(4:5)

max_rules()
}
