% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_system_async.R
\name{upload_async}
\alias{upload_async}
\alias{s3_file_upload_async}
\alias{s3_dir_upload_async}
\title{Upload file and directory}
\usage{
s3_file_upload_async(
  path,
  new_path,
  max_batch = fs_bytes("100MB"),
  overwrite = FALSE,
  ...
)

s3_dir_upload_async(path, new_path, max_batch, overwrite = FALSE, ...)
}
\arguments{
\item{path}{(character): A character vector of local file paths to upload to AWS S3}

\item{new_path}{(character): A character vector of AWS S3 paths or uri's of the new locations.}

\item{max_batch}{(\link[fs]{fs_bytes}): Maximum batch size being uploaded with each multipart.}

\item{overwrite}{(logical): Overwrite files if the exist. If this is \code{FALSE}
and the file exists an error will be thrown.}

\item{...}{parameters to be passed to \code{\link[paws.storage]{s3_put_object}}
and \code{\link[paws.storage]{s3_create_multipart_upload}}}
}
\value{
return \code{\link[future]{future}} object of \code{\link[=s3_file_upload]{s3_file_upload()}} \code{\link[=s3_dir_upload]{s3_dir_upload()}}
}
\description{
\code{s3_file_upload} upload files to AWS S3

\code{s3_dir_upload} upload directory to AWS S3
}
\seealso{
\code{\link[future]{future}} \code{\link[=s3_file_move]{s3_file_move()}} \code{\link[=s3_file_upload]{s3_file_upload()}} \code{\link[=s3_dir_upload]{s3_dir_upload()}}
}
