% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_ts.R
\name{sim_ts}
\alias{sim_ts}
\title{Simulate a Time Series}
\usage{
sim_ts(n, b0 = 0, bt = 0, rho = 1, white_noise = FALSE, rsd = 1)
}
\arguments{
\item{n}{a numeric vector for the length of the series}

\item{b0}{a numeric vector for a potential drift in the series. Defaults to 0}

\item{bt}{a numeric vector for a potential trend in the series. Defaults to 0.}

\item{rho}{a numeric vector for the simple autoregressive parameter. Defaults to 1.}

\item{white_noise}{= logical, defaults to FALSE. If FALSE, generates a random
walk. If TRUE, series is white noise.}

\item{rsd}{the standard deviation for a normal distribution to be simulated. Defaults to 1.}
}
\value{
\code{sim_ts()} returns a numeric vector of a simulated time series
that would follow the user's input.
}
\description{
\code{sim_ts()} is mostly a helper function, to be used
internally in this package, but you can use it here to simulate a time series.
}
\examples{

set.seed(8675309) # don't want new numbers in documentation every time...

sim_ts(25)

sim_ts(25, b0 = 1)

sim_ts(25, b0 = 1, bt = .05)

}
\author{
Steven V. Miller
}
