% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-arithmetic.r
\name{Arithmetic}
\alias{Arithmetic}
\alias{+,dual,dual-method}
\alias{+,dual,numericOrArray-method}
\alias{+,numericOrArray,dual-method}
\alias{+,dual,missing-method}
\alias{-,dual,dual-method}
\alias{-,dual,missing-method}
\alias{-,dual,numericOrArray-method}
\alias{-,numericOrArray,dual-method}
\alias{*,dual,dual-method}
\alias{*,dual,numeric-method}
\alias{*,numeric,dual-method}
\alias{/,dual,numeric-method}
\alias{/,numeric,dual-method}
\alias{/,dual,dual-method}
\alias{^,dual,numeric-method}
\alias{^,numeric,dual-method}
\alias{^,dual,dual-method}
\title{Arithmetic Operators}
\usage{
\S4method{+}{dual,dual}(e1, e2)

\S4method{+}{dual,numericOrArray}(e1, e2)

\S4method{+}{numericOrArray,dual}(e1, e2)

\S4method{+}{dual,missing}(e1, e2)

\S4method{-}{dual,dual}(e1, e2)

\S4method{-}{dual,missing}(e1, e2)

\S4method{-}{dual,numericOrArray}(e1, e2)

\S4method{-}{numericOrArray,dual}(e1, e2)

\S4method{*}{dual,dual}(e1, e2)

\S4method{*}{dual,numeric}(e1, e2)

\S4method{*}{numeric,dual}(e1, e2)

\S4method{/}{dual,numeric}(e1, e2)

\S4method{/}{numeric,dual}(e1, e2)

\S4method{/}{dual,dual}(e1, e2)

\S4method{^}{dual,numeric}(e1, e2)

\S4method{^}{numeric,dual}(e1, e2)

\S4method{^}{dual,dual}(e1, e2)
}
\arguments{
\item{e1}{object of class 'dual' or 'numeric'}

\item{e2}{object of class 'dual' or 'numeric'}
}
\value{
An object of class 'dual'.
}
\description{
Arithmetic operators for objects of class 'dual'
}
\details{
The usual operations are performed, with appropriate propagation of the derivatives
}
\examples{
x <- dual( c(1,2) )
a <- 2 * x + 3
a
d(a)
b <- x[1] + 3*x[2]
b
d(b)
}
