% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_gls.R
\name{plot.replext_gls}
\alias{plot.replext_gls}
\title{Plot Results from Replications and Extension of GLS Simulation}
\usage{
\method{plot}{replext_gls}(
  x,
  term,
  metric = "rejection_rates",
  x_axis = "tppp",
  color = "rho",
  title = NULL,
  x_label = NULL,
  y_label = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class "replext_gls", typically the output from replext_gls().}

\item{term}{Character. The name of the model term to plot.}

\item{metric}{Character. The metric to plot on the y-axis. Default is "rejection_rates".
Other options include "mean_estimates", "mean_bias", etc.}

\item{x_axis}{Character. The variable to plot on the x-axis. Default is "tppp"
(time points per phase).}

\item{color}{Character. The variable to use for color grouping. Default is "rho"
(autocorrelation parameter).}

\item{title}{Character. The plot title. If NULL, a default title is generated.}

\item{x_label}{Character. The x-axis label. If NULL, a default label is generated.}

\item{y_label}{Character. The y-axis label. If NULL, a default label is generated.}

\item{...}{Pass extra arguments to ggplot.}
}
\value{
A ggplot2 object representing the plot.
}
\description{
This method creates a ggplot2 visualization of results from a replext_gls object.
It allows for flexible plotting of different metrics across various conditions.
}
\details{
This method creates a line plot with points, where each line represents a different
level of the color variable (default is rho). If the metric is "rejection_rates",
error bars are added to represent the standard error of the rejection rates.
}
\examples{
results <- replext_gls(
  n_timepoints_list = c(10),
  rho_list = c(0.2),
  iterations = 10,
  betas = c("(Intercept)" = 0, "phase1" = 1),
  formula = y ~ phase
)
plot(results, term = "phase1", metric = "rejection_rates")

}
