% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_labels.R
\name{add_labels}
\alias{add_labels}
\title{Add value labels to an scplot}
\usage{
add_labels(
  object,
  nudge_y = 5,
  nudge_x = 0,
  round = NULL,
  text = list(),
  background = list(),
  variable = ".dvar",
  padding = NULL
)
}
\arguments{
\item{object}{An scplot object (class \code{scplot}) returned from the \code{scplot()}
function.}

\item{nudge_y}{Offset on the y-axis.}

\item{nudge_x}{Offset on the x-axis.}

\item{round}{Number of digits of the labels.}

\item{text}{List with text parameters (\verb{"family", "face", "colour", "size", "hjust", "vjust", "angle", "lineheight", "margin"}). See \code{\link[=element_text]{element_text()}}.}

\item{background}{A list with background styling arguments (fill, color,
size, linetype).}

\item{variable}{Name of the dataline variable to apply the style.}

\item{padding}{Padding size around text.}
}
\value{
An object of class \code{scplot} (see\code{\link[=scplot]{scplot()}}) with added/changed element
\code{labels}.
}
\description{
Add value labels to an scplot
}
