% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_marks.R
\name{add_marks}
\alias{add_marks}
\title{Add marks to an scplot}
\usage{
add_marks(
  object,
  case = 1,
  positions,
  color = "red",
  size = 1,
  shape = 1,
  variable = ".dvar"
)
}
\arguments{
\item{object}{An scplot object (class \code{scplot}) returned from the \code{scplot()}
function.}

\item{case}{Numerical vector with the case number or character string. \code{case = "all"} for all cases.}

\item{positions}{Either a vector indicating the points to be highlighted or a
character string with a logical expression (e.g. \code{values < mean(values)})}

\item{color}{A character string or a number defining the color of an element.}

\item{size}{Text size relative to the base text size.}

\item{shape}{Number. See \code{pch} graphical parameter on \code{par} help page
\code{\link[=par]{par()}}.}

\item{variable}{Name of the dataline variable to apply the style.}
}
\value{
An object of class \code{scplot} (see \code{\link[=scplot]{scplot()}}) with changed element
\code{marks}.
}
\description{
Add marks to an scplot
}
\details{
If \code{positions} is an object returned from an outlier analysis
\code{outlier()}, the corresponding outliers are marked.
}
\examples{
library(scan)
p1 <- scplot(exampleA1B1A2B2$Moritz) |> add_marks(positions = c(1,5,10,14))
p1 <- scplot(Huber2014) |> add_marks(positions = outlier(Huber2014))
}
