% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{screenshotbase_take}
\alias{screenshotbase_take}
\title{Take a website screenshot}
\usage{
screenshotbase_take(
  url,
  format = NULL,
  quality = NULL,
  full_page = NULL,
  viewport_width = NULL,
  viewport_height = NULL,
  apikey = NULL
)
}
\arguments{
\item{url}{URL of the website to render (required).}

\item{format}{Image format: one of \code{"png"}, \code{"jpg"}, \code{"jpeg"}, \code{"gif"}.}

\item{quality}{Integer quality for jpg/jpeg (defaults to 80 on server if not set).}

\item{full_page}{Logical; capture full page.}

\item{viewport_width, viewport_height}{Integers for viewport size in pixels.}

\item{apikey}{Optional API key to override the session key.}
}
\value{
A raw vector of the image content.
}
\description{
Renders a website and returns raw image bytes.
}
\examples{
\dontrun{
set_api_key("YOUR-API-KEY")
bytes <- screenshotbase_take("https://bbc.com", format = "png", full_page = TRUE)
writeBin(bytes, "screenshot.png")
}
}

