% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/denoise.R
\name{correct}
\alias{correct}
\title{Correct data by setting all latent factors to their median values and reversing the regression model}
\usage{
correct(
  x,
  data = "y",
  cell_attr = x$cell_attr,
  as_is = FALSE,
  do_round = TRUE,
  do_pos = TRUE,
  scale_factor = NA,
  verbosity = 2
)
}
\arguments{
\item{x}{A list that provides model parameters and optionally meta data; use output of vst function}

\item{data}{The name of the entry in x that holds the data}

\item{cell_attr}{Provide cell meta data holding latent data info}

\item{as_is}{Use cell attributes as is and do not use the median; set to TRUE if you want to
manually control the values of the latent factors; default is FALSE}

\item{do_round}{Round the result to integers}

\item{do_pos}{Set negative values in the result to zero}

\item{scale_factor}{Replace all values of UMI in the regression model by this value. Default is NA
which uses median of total UMI as the latent factor.}

\item{verbosity}{An integer specifying the verbosity level: 0 (silent, no messages), 1 (show messages only), or 2 (show messages and progress bars); default is 2}
}
\value{
Corrected data as UMI counts
}
\description{
Correct data by setting all latent factors to their median values and reversing the regression model
}
\examples{
\donttest{
vst_out <- vst(pbmc, return_cell_attr = TRUE)
umi_corrected <- correct(vst_out)
}

}
