% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubmed-connector.R
\name{complete_search_workflow}
\alias{complete_search_workflow}
\title{Complete Search and Analysis Workflow}
\usage{
complete_search_workflow(
  search_terms,
  databases = "pubmed",
  gold_standard = NULL,
  max_results = 100,
  date_range = NULL,
  output_dir = NULL
)
}
\arguments{
\item{search_terms}{Character vector of search terms}

\item{databases}{Vector of databases to search}

\item{gold_standard}{Optional vector of known relevant article IDs}

\item{max_results}{Maximum results to retrieve}

\item{date_range}{Optional date range for search}

\item{output_dir}{Directory for reports (uses tempdir() by default)}
}
\value{
List containing search results, analysis, and report paths
}
\description{
Perform a complete workflow: search databases, analyze results, generate reports.
}
\examples{
\donttest{
# Complete workflow
results <- complete_search_workflow(
  search_terms = "diabetes treatment clinical trial",
  databases = "pubmed",
  max_results = 50,
  date_range = c("2022/01/01", "2023/12/31")
)

# View summary
print(results$summary)

# Access detailed metrics
print(results$analysis$metrics)
}

}
