% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrt_gknown.R
\name{like_gknown_3}
\alias{like_gknown_3}
\title{Likelihood under three parameter model when genotypes are known}
\usage{
like_gknown_3(x, tau, beta, gamma1, gamma2, g1, g2, log_p = TRUE, pen = 0)
}
\arguments{
\item{x}{A vector of length 5. \code{x[i]} is the count of individuals with
genotype \code{i-1}.}

\item{tau}{The probability of quadrivalent formation.}

\item{beta}{The probability of double reduction given quadrivalent formation.}

\item{gamma1}{The probability of AA_aa pairing for parent 1.}

\item{gamma2}{The probability of AA_aa pairing for parent 2.}

\item{g1}{Parent 1's genotype.}

\item{g2}{Parent 2's genotype.}

\item{log_p}{A logical. Should we return the log likelihood or not?}

\item{pen}{A tiny penalty to help with numerical stability}
}
\value{
The (log) likelihood.
}
\description{
This is under the three parameter model.
}
\examples{
x <- c(1, 4, 5, 3, 1)
tau <- 0.5
beta <- 0.1
gamma1 <- 0.5
gamma2 <- 0.3
g1 <- 1
g2 <- 2
like_gknown_3(
  x = x,
  tau = tau,
  beta = beta,
  gamma1 = gamma1,
  gamma2 = gamma2,
  g1 = g1,
  g2 = g2)

}
\author{
David Gerard
}
